<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();

            $table->string('content_id')->nullable();
            $table->string('external_id')->unique();
            $table->string('client_ip_address', 45)->nullable();
            $table->text('client_user_agent')->nullable();
            $table->string('fbp')->nullable();
            $table->string('fbc')->nullable();

            $table->string('country', 100)->nullable();
            $table->string('state', 100)->nullable();
            $table->string('city', 100)->nullable();
            $table->string('postal_code', 10)->nullable();

            $table->string('first_name')->nullable();
            $table->string('last_name')->nullable();
            $table->string('email')->nullable();
            $table->string('phone', 20)->nullable();

            $table->string('url', 2048)->nullable();

            $table->string('first_utm_source')->nullable();
            $table->string('first_utm_campaign')->nullable();
            $table->string('first_utm_medium')->nullable();
            $table->string('first_utm_content')->nullable();
            $table->string('first_utm_term')->nullable();

            $table->string('last_utm_source')->nullable();
            $table->string('last_utm_campaign')->nullable();
            $table->string('last_utm_medium')->nullable();
            $table->string('last_utm_content')->nullable();
            $table->string('last_utm_term')->nullable();

            $table->timestamps(0);
        });
    }

    public function down()
    {
        Schema::dropIfExists('users');
    }
}
