<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\File;

class InstallController extends Controller
{
    public function run()
    {
        $lockFile = storage_path('installed.lock');

        if (File::exists($lockFile)) {
            return response()->json(['message' => 'A instalacao ja foi feita.'], 403);
        }

        // Executar comandos
        Artisan::call('key:generate');
        Artisan::call('migrate', ['--force' => true]);
        Artisan::call('config:clear');
        Artisan::call('cache:clear');
        Artisan::call('route:clear');
        Artisan::call('view:clear');

        // Criar arquivo de trava
        File::put($lockFile, now());

        return response()->json(['message' => 'Instalacao concluida com sucesso!']);
    }
}
